/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.validacion;

import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.UtilitarioCaracteresRepetidos;
import java.util.regex.Pattern;

public class ValidacionIdentificacion {
    public static final String NA = "NA";
    public static final String CEDULA = "C";
    public static final String PASAPORTE = "P";
    public static final String RUC = "R";
    public static final String REGEX_LETRAS_NUMEROS_ESPACIOS = "[a-zA-Z0-9\\s]*";
    public static final String REGEX_LETRAS_NUMEROS = "[a-zA-Z0-9]*";
    public static final String REGEX_NUMEROS = "[0-9]*";
    private static final String REGEX_SEIS_CERO_O_NUEVE = "[9]{7}|[0]{7}|[9]{13}|[0]{13}";
    public static String CONSUMINDOR_FINAL = "9999999999999";

    public static EstadoValidacionCedula validarCedula(String cedula) {
        if (cedula.length() != 10) {
            return EstadoValidacionCedula.LONGITUD_NO_VALIDA;
        }
        if (!Pattern.matches(REGEX_NUMEROS, cedula)) {
            return EstadoValidacionCedula.CARACTERES_NO_VALIDOS;
        }
        if (!ValidacionIdentificacion.isValidCedula(cedula)) {
            return EstadoValidacionCedula.VALOR_MAL_FORMADO;
        }
        return EstadoValidacionCedula.CORRECTO;
    }

    public static EstadoValidacionRUC validarRUC(String ruc) {
        if (ruc.length() != 13) {
            return EstadoValidacionRUC.LONGITUD_NO_VALIDA;
        }
        if (!Pattern.matches(REGEX_NUMEROS, ruc)) {
            return EstadoValidacionRUC.CARACTERES_NO_VALIDOS;
        }
        if (!ruc.endsWith("001")) {
            return EstadoValidacionRUC.SUFIJO_INCORRECTO;
        }
        if (!ValidacionIdentificacion.isValidRuc(ruc)) {
            return EstadoValidacionRUC.VALOR_MAL_FORMADO;
        }
        return EstadoValidacionRUC.CORRECTO;
    }

    public static EstadoValidacionPasaporte validarPasaporte(String pasaporte, int minimo, int maximo) {
        if (pasaporte.length() < minimo || pasaporte.length() > maximo) {
            return EstadoValidacionPasaporte.LONGITUD_NO_VALIDA;
        }
        if (!Pattern.matches(REGEX_LETRAS_NUMEROS, pasaporte)) {
            return EstadoValidacionPasaporte.CARACTERES_NO_VALIDOS;
        }
        if (Pattern.matches(REGEX_SEIS_CERO_O_NUEVE, pasaporte)) {
            return EstadoValidacionPasaporte.FORMATO_INCORRECTO;
        }
        return EstadoValidacionPasaporte.CORRECTO;
    }

    public static ResultadoValidacion validarTodaIdentificacion(String tipo, String identificacion, ResultadoValidacion resultado, Integer minimo, Integer maximo) {
        if (tipo.equals(CEDULA)) {
            EstadoValidacionCedula estado = ValidacionIdentificacion.validarCedula(identificacion);
            switch (estado) {
                case LONGITUD_NO_VALIDA: {
                    return resultado.fallarValidacion("El n\u00famero de c\u00e9dula debe tener 10 d\u00edgitos.");
                }
                case VALOR_MAL_FORMADO: {
                    return resultado.fallarValidacion("El n\u00famero de c\u00e9dula ingresado no es v\u00e1lido.");
                }
                case CARACTERES_NO_VALIDOS: {
                    return resultado.fallarValidacion("El n\u00famero de c\u00e9dula contiene caracteres no v\u00e1lidos.");
                }
            }
        } else if (tipo.equals(RUC)) {
            EstadoValidacionRUC estado = ValidacionIdentificacion.validarRUC(identificacion);
            switch (estado) {
                case LONGITUD_NO_VALIDA: {
                    return resultado.fallarValidacion("El n\u00famero de RUC debe tener 13 d\u00edgitos.");
                }
                case SUFIJO_INCORRECTO: {
                    return resultado.fallarValidacion("El n\u00famero de RUC debe terminar en 001.");
                }
                case VALOR_MAL_FORMADO: {
                    return resultado.fallarValidacion("El n\u00famero de RUC ingresado no es v\u00e1lido.");
                }
                case CARACTERES_NO_VALIDOS: {
                    return resultado.fallarValidacion("El n\u00famero de RUC contiene caracteres no v\u00e1lidos.");
                }
            }
        } else if (tipo.equals(PASAPORTE)) {
            EstadoValidacionPasaporte estado = ValidacionIdentificacion.validarPasaporte(identificacion, minimo, maximo);
            switch (estado) {
                case LONGITUD_NO_VALIDA: {
                    return resultado.fallarValidacion("El n\u00famero de pasaporte debe tener entre " + minimo + " y " + maximo + " d\u00edgitos de longitud.");
                }
                case CARACTERES_NO_VALIDOS: {
                    return resultado.fallarValidacion("El n\u00famero de pasaporte contiene caracteres no v\u00e1lidos.");
                }
                case FORMATO_INCORRECTO: {
                    return resultado.fallarValidacion(String.format("El n\u00famero de pasaporte tiene un formato no v\u00e1lido %s.", identificacion));
                }
            }
        } else {
            switch (ValidacionIdentificacion.validarPasaporte(identificacion, minimo, maximo)) {
                case LONGITUD_NO_VALIDA: {
                    return resultado.fallarValidacion("El n\u00famero de identificaci\u00f3n extranjera debe tener entre " + minimo + " y " + maximo + " d\u00edgitos de longitud.");
                }
                case CARACTERES_NO_VALIDOS: {
                    return resultado.fallarValidacion("El n\u00famero de identificaci\u00f3n extranjera contiene caracteres no v\u00e1lidos.");
                }
            }
            UtilitarioCaracteresRepetidos validador = new UtilitarioCaracteresRepetidos(identificacion);
            if (!validador.validar()) {
                return resultado.pasarValidacionAdvertencia("La identificaci\u00f3n ingresada contiene n\u00fameros secuenciales, solo letras o repetici\u00f3n de un mismo car\u00e1cter varias veces. Debe reportar un n\u00famero o c\u00f3digo de identificaci\u00f3n fiscal otorgado por un organismo del Estado de donde sea residente.");
            }
        }
        return resultado.pasarValidacion();
    }

    public static ResultadoValidacion validarOtrasIdentificaciones(String tipo, String identificacion, ResultadoValidacion resultado, Integer minimo, Integer maximo, String mensaje) {
        EstadoValidacionPasaporte estado = ValidacionIdentificacion.validarPasaporte(identificacion, minimo, maximo);
        switch (estado) {
            case LONGITUD_NO_VALIDA: {
                return resultado.fallarValidacion(String.format("El n\u00famero de %s debe tener entre %d y %d d\u00edgitos de longitud.", mensaje, minimo, maximo));
            }
            case CARACTERES_NO_VALIDOS: {
                return resultado.fallarValidacion(String.format("El n\u00famero de %s contiene caracteres no v\u00e1lidos.", mensaje));
            }
            case FORMATO_INCORRECTO: {
                return resultado.fallarValidacion(String.format("El n\u00famero de pasaporte tiene un formato no v\u00e1lido %s", mensaje));
            }
        }
        return resultado.pasarValidacion();
    }

    public static boolean isValidCedula(String cedula) {
        return ValidacionIdentificacion.validaIdentificacion('C', cedula);
    }

    public static boolean isValidRuc(String ruc) {
        return ValidacionIdentificacion.validaIdentificacion('R', ruc);
    }

    public static boolean validaIdentificacion(char tipoDocumento, String identificacion) {
        if (tipoDocumento == 'F' && identificacion.equals(CONSUMINDOR_FINAL)) {
            return true;
        }
        if (tipoDocumento == 'P') {
            return identificacion.length() > 0;
        }
        String numeroIdentificacion = new String();
        String cedula = new String();
        boolean rc = false;
        try {
            new Long(identificacion);
        }
        catch (Exception exception) {
            return false;
        }
        numeroIdentificacion = identificacion;
        if (tipoDocumento == 'R' && identificacion.length() != 13) {
            return false;
        }
        if ((tipoDocumento == 'C' || tipoDocumento == 'c') && identificacion.length() != 10) {
            return false;
        }
        if (tipoDocumento == 'R' && !identificacion.substring(10).equals("001")) {
            return false;
        }
        cedula = identificacion.substring(0, 10);
        int vec3 = Integer.parseInt(numeroIdentificacion.substring(2, 3));
        if (vec3 >= 0 && vec3 <= 5 || tipoDocumento == 'C') {
            rc = ValidacionIdentificacion.validaCedula(cedula);
            if (!rc && tipoDocumento == 'R') {
                rc = true;
            }
        } else if (vec3 == 6) {
            rc = ValidacionIdentificacion.validaTercero6(cedula);
            rc = ValidacionIdentificacion.habilitarValidacion(rc);
        } else if (vec3 == 9) {
            rc = ValidacionIdentificacion.validaTercero9(cedula);
            rc = ValidacionIdentificacion.habilitarValidacion(rc);
        }
        return rc;
    }

    private static boolean validaCedula(String cedula) {
        int digito;
        int digito10 = Integer.parseInt(cedula.substring(9));
        int suma = 0;
        int cont = 0;
        int contPos = 0;
        while (contPos < 9) {
            contPos = 2 * cont + 1;
            digito = Integer.parseInt(cedula.substring(contPos - 1, contPos));
            int multi = digito * 2;
            if (multi >= 10) {
                multi = 1 + multi % 10;
            }
            suma += multi;
            ++cont;
        }
        cont = 1;
        contPos = 1;
        while (contPos < 8) {
            contPos = 2 * cont;
            digito = Integer.parseInt(cedula.substring(contPos - 1, contPos));
            suma += digito;
            ++cont;
        }
        int cociente = suma / 10;
        int decena = (cociente + 1) * 10;
        int verificador = decena - suma;
        if (verificador == 10) {
            verificador = 0;
        }
        return verificador == digito10;
    }

    private static boolean validaTercero6(String cedula) {
        int digito1 = Integer.parseInt(cedula.substring(0, 1)) * 3;
        int digito2 = Integer.parseInt(cedula.substring(1, 2)) * 2;
        int digito3 = Integer.parseInt(cedula.substring(2, 3)) * 7;
        int digito4 = Integer.parseInt(cedula.substring(3, 4)) * 6;
        int digito5 = Integer.parseInt(cedula.substring(4, 5)) * 5;
        int digito6 = Integer.parseInt(cedula.substring(5, 6)) * 4;
        int digito7 = Integer.parseInt(cedula.substring(6, 7)) * 3;
        int digito8 = Integer.parseInt(cedula.substring(7, 8)) * 2;
        boolean respuesta = false;
        digito1 = ValidacionIdentificacion.sumaDigito(digito1);
        digito2 = ValidacionIdentificacion.sumaDigito(digito2);
        digito3 = ValidacionIdentificacion.sumaDigito(digito3);
        digito4 = ValidacionIdentificacion.sumaDigito(digito4);
        digito5 = ValidacionIdentificacion.sumaDigito(digito5);
        digito6 = ValidacionIdentificacion.sumaDigito(digito6);
        digito7 = ValidacionIdentificacion.sumaDigito(digito7);
        digito8 = ValidacionIdentificacion.sumaDigito(digito8);
        int suma = digito1 + digito2 + digito3 + digito4 + digito5 + digito6 + digito7 + digito8;
        int suma2 = Integer.parseInt(cedula.substring(0, 1)) * 3 + Integer.parseInt(cedula.substring(1, 2)) * 2 + Integer.parseInt(cedula.substring(2, 3)) * 7 + Integer.parseInt(cedula.substring(3, 4)) * 6 + Integer.parseInt(cedula.substring(4, 5)) * 5 + Integer.parseInt(cedula.substring(5, 6)) * 4 + Integer.parseInt(cedula.substring(6, 7)) * 3 + Integer.parseInt(cedula.substring(7, 8)) * 2;
        int verificador = 11 - suma % 11;
        int verificador2 = 11 - suma2 % 11;
        if (verificador == 11 || verificador2 == 11) {
            verificador = 0;
        }
        respuesta = verificador == Integer.parseInt(cedula.substring(8, 9)) || verificador2 == Integer.parseInt(cedula.substring(8, 9)) ? true : ValidacionIdentificacion.validaCedula(cedula);
        return respuesta;
    }

    private static int sumaDigito(Integer digito) {
        int suma = digito;
        int valor1 = 0;
        int valor2 = 0;
        if (digito > 9 && (suma = (valor1 = Integer.parseInt(digito.toString().substring(0, 1))) + (valor2 = Integer.parseInt(digito.toString().substring(1, 2)))) > 9) {
            suma = ValidacionIdentificacion.sumaDigito(suma);
        }
        return suma;
    }

    private static boolean validaTercero9(String cedula) {
        int digito1 = Integer.parseInt(cedula.substring(0, 1));
        int digito2 = Integer.parseInt(cedula.substring(1, 2));
        int digito3 = Integer.parseInt(cedula.substring(2, 3));
        int digito4 = Integer.parseInt(cedula.substring(3, 4));
        int digito5 = Integer.parseInt(cedula.substring(4, 5));
        int digito6 = Integer.parseInt(cedula.substring(5, 6));
        int digito7 = Integer.parseInt(cedula.substring(6, 7));
        int digito8 = Integer.parseInt(cedula.substring(7, 8));
        int digito9 = Integer.parseInt(cedula.substring(8, 9));
        int digito10 = Integer.parseInt(cedula.substring(9));
        int suma = digito1 * 4 + digito2 * 3 + digito3 * 2 + digito4 * 7 + digito5 * 6 + digito6 * 5 + digito7 * 4 + digito8 * 3 + digito9 * 2;
        int verificador = 11 - suma % 11;
        if (verificador == 11) {
            verificador = 0;
        }
        if (verificador == 10) {
            return false;
        }
        return verificador == digito10;
    }

    private static boolean habilitarValidacion(boolean respuesta) {
        if (!respuesta) {
            respuesta = true;
        }
        return respuesta;
    }

    public static enum EstadoValidacionCedula {
        CORRECTO,
        LONGITUD_NO_VALIDA,
        VALOR_MAL_FORMADO,
        CARACTERES_NO_VALIDOS;

    }

    public static enum EstadoValidacionPasaporte {
        CORRECTO,
        LONGITUD_NO_VALIDA,
        CARACTERES_NO_VALIDOS,
        FORMATO_INCORRECTO;

    }

    public static enum EstadoValidacionRUC {
        CORRECTO,
        LONGITUD_NO_VALIDA,
        VALOR_MAL_FORMADO,
        SUFIJO_INCORRECTO,
        CARACTERES_NO_VALIDOS;

    }
}

